
#include <windows.h>

#define OEB_ISGENERATOR  15
#define OEB_ISEFFECT     12
#define OEB_ISGEAR       4
#define OEB_ISRECORDER   14
#define OEB_ISWAVEOUT    7
#define OEB_ISMAINBUZZ   0

int oeblib150_library_loaded;
char oeblib150_myappdir[255];
char *(__cdecl *oeblib_GetVersion)(void);
HWND (__cdecl *oeblib_GetMainBuzzWindow)(void);
int (__cdecl *oeblib_GetTuning)(void);
float (__cdecl *oeblib_GetManualTuning)(void);
int (__cdecl *oeblib_GetQuality)(void);
int (__cdecl *oeblib_GetComponentLoaded)(int);

char * OEB_GetVersion() { if (oeblib150_library_loaded == 1) { return oeblib_GetVersion(); } else { return ("Overloader and\\or OEB not Loaded"); } }
HWND OEB_GetBuzzWindow() { HWND buf; if (oeblib150_library_loaded == 1) { buf = oeblib_GetMainBuzzWindow(); } else { buf = GetForegroundWindow(); } return buf; }
int OEB_GetTuning() { if (oeblib150_library_loaded == 1) { return oeblib_GetTuning(); } else { return -1; } }
float OEB_GetManualTuning() { if (oeblib150_library_loaded == 1) {return oeblib_GetManualTuning();} else { return 0.0f; } }
int OEB_GetQuality() {if (oeblib150_library_loaded == 1) { return oeblib_GetQuality(); } else { return -1; } }
int OEB_GetComponentLoaded(int component_id) { if (oeblib150_library_loaded == 1) { return oeblib_GetComponentLoaded(component_id); } else { return -1; } }

void LoadGeneralOEB(int machine_type, HINSTANCE dllInst) {
	char baba[256], baba2[256];
	char thestrdata[200];
	char *filen;
	GetModuleFileName(dllInst,baba,256);
	GetFullPathName(baba,256,baba2,&filen);
	sprintf(filen,"\0");
	sprintf(&baba2[(int)(strlen(baba2) - 2 - machine_type)],"\0");
	sprintf(oeblib150_myappdir,baba2);
	sprintf(thestrdata, "%s\\overloader extbuzz.dll", oeblib150_myappdir);
	HMODULE h_dll=LoadLibrary(thestrdata);
	if(h_dll==NULL) {
		oeblib150_library_loaded = 0;
		// Loading OEB failed
	} else {
		oeblib150_library_loaded = 1;
		oeblib_GetMainBuzzWindow=(HWND (__cdecl *)(void))GetProcAddress(h_dll,"OEBGetMainBuzzWindow");
		oeblib_GetVersion=(char *(__cdecl *)(void))GetProcAddress(h_dll,"OEBGetVersionText");
		oeblib_GetQuality=(int (__cdecl *)(void))GetProcAddress(h_dll,"OEBGetQuality");
		oeblib_GetManualTuning=(float (__cdecl *)(void))GetProcAddress(h_dll,"OEBGetManualTuning");
		oeblib_GetTuning=(int (__cdecl *)(void))GetProcAddress(h_dll,"OEBGetTuning");
		oeblib_GetComponentLoaded=(int (__cdecl *)(int))GetProcAddress(h_dll,"OEBGetComponentLoaded");
	}
}

